<?php

/**
 * Admin class
 * responsible for adding the new integration settings
 */
class IPT_FSQM_MC_Init {
	public $that;
	public $ui;

	public static $instance;

	public static function init() {
		if ( ! self::$instance instanceof IPT_FSQM_MC_Init ) {
			self::$instance = new IPT_FSQM_MC_Init();
		}

		return self::$instance;
	}

	public function __construct() {
		// add filter for settings
		add_filter( 'ipt_fsqm_filter_default_settings', array( $this, 'modify_settings' ), 10, 2 );

		// add filter for integration tab
		add_filter( 'ipt_fsqm_integration_settings_tabs', array( $this, 'modify_tabs' ), 10, 2 );
	}

	public function modify_settings( $settings, $form_id ) {
		$settings['integration']['mycred'] = array(
			'enabled' => false,
			'limit_by' => 'no',
			'limit_day' => '',
			'disable_neg' => false,
			'point_type' => 'static', // can be static | mathematical | score
			'static_point' => '1',
			'mid' => '', // mathematical field ID
			'multiplier' => '1', // valid only for mathematical | score
			'disabled_pt' => array(),
		);

		return $settings;
	}

	public function modify_tabs( $tabs, $that ) {
		$this->that = $that;
		$tabs[] = array(
			'id' => 'ipt_fsqm_settings_mycred',
			'label' => __( 'myCRED Awards', 'ipt_fsqm_mc' ),
			'callback' => array( $this, 'mycred_tab_cb' ),
		);
		return $tabs;
	}

	public function mycred_tab_cb() {
		$op = $this->that->settings['integration']['mycred'];
		$this->ui = $this->that->ui;
		$point_type = array(
			0 => array(
				'label' => __( 'Static Point', 'ipt_fsqm_mc' ),
				'value' => 'static',
				'data'  => array(
					'condid' => 'ipt_fsqm_intg_mc_sp',
				),
			),
			1 => array(
				'label' => __( 'Score Obtained', 'ipt_fsqm_mc' ),
				'value' => 'score',
				'data'  => array(
					'condid' => 'ipt_fsqm_intg_mc_mul',
				),
			),
			2 => array(
				'label' => __( 'Mathematical Element', 'ipt_fsqm_mc' ),
				'value' => 'mathematical',
				'data'  => array(
					'condid' => 'ipt_fsqm_intg_mc_mid,ipt_fsqm_intg_mc_mul',
				),
			),
		);
		$limit_by = array(
			'no' => __( 'Global Settings', 'ipt_fsqm_mc' ),
			'none' => __( 'No limits', 'ipt_fsqm_mc' ),
			'form'  => __( 'Once for each form', 'ipt_fsqm_mc' ),
			'day'   => __( 'Once for every n days', 'ipt_fsqm_mc' ),
			'formday' => __( 'Once for each form per n days', 'ipt_fsqm_mc' ),
		);
		$mycred_types = mycred_get_types();
		?>
<table class="form-table">
	<tbody>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][enabled]', __( 'Enable myCRED Rewards', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->toggle( 'settings[integration][mycred][enabled]', __( 'Yes', 'ipt_fsqm_mc' ), __( 'No', 'ipt_fsqm_mc' ), $op['enabled'], '1', false, true, array(
					'condid' => 'ipt_fsqm_intg_mc_set'
				) ); ?>
			</td>
			<td>
				<?php $this->ui->help( sprintf( __( 'If you want to reward your users points for submitting this form, enable this settings. It works only with myCRED plugin. Additionally you also need to enable <a href="%1$s" target="_blank">Points for FSQM form submissions</a> under myCRED plugin.', 'ipt_fsqm_mc' ), admin_url( 'admin.php?page=myCRED_page_hooks' ) ) ); ?>
			</td>
		</tr>
	</tbody>
</table>
<table class="form-table" id="ipt_fsqm_intg_mc_set">
	<tbody>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][limit_by]', __( 'Override Limits', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->select( 'settings[integration][mycred][limit_by]', $limit_by, $op['limit_by'] ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'This will override the global settings.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][limit_day]', __( 'Override Days Limit', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[integration][mycred][limit_day]', $op['limit_day'], __( 'Use Global', 'ipt_fsqm_mc' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'If you choose limit by n days or limit by each form per n days then you can specify the number of days here. This will also override the global settings.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][point_type]', __( 'Reward Point Type', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->select( 'settings[integration][mycred][point_type]', $point_type, $op['point_type'], false, true ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Set the award point type. You can choose between static point, mathematical evaluator and score obtaiend in the form. Negative score would reduce points.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][disable_neg]', __( 'Do not subtract points for score and mathematical', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->toggle( 'settings[integration][mycred][disable_neg]', __( 'Yes', 'ipt_fsqm_mc' ), __( 'No', 'ipt_fsqm_mc' ), $op['disable_neg'] ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Dynamic points such as score and mathematical can result in negative values. By default it will be subtracted from user points. If you wish to disable this and only want to award positive points then enable this settings.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_intg_mc_sp">
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][static_point]', __( 'Reward Point', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[integration][mycred][static_point]', $op['static_point'], __( 'Number', 'ipt_fsqm_mc' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enter the award point value.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_intg_mc_mid">
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][mid]', __( 'Mathematical Field ID', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[integration][mycred][mid]', $op['mid'], __( 'Number', 'ipt_fsqm_mc' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'ID of the mathematical field against which the award point is to be calculated.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_intg_mc_mul">
			<th><?php $this->ui->generate_label( 'settings[integration][mycred][multiplier]', __( 'Calculation Multiplier', 'ipt_fsqm_mc' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[integration][mycred][multiplier]', $op['multiplier'], __( 'Number', 'ipt_fsqm_mc' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'The actual reward point would be multiplied with this value. Make sure it is set to 1 if you do not wish to change.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_intg_mc_bpt">
			<th>
				<?php $this->ui->generate_label( 'settings[integration][mycred][disabled_pt]', __( 'Disabled Points Type', 'ipt_fsqm_mc' ) ); ?>
			</th>
			<td>
				<?php $this->ui->checkboxes( 'settings[integration][mycred][disabled_pt][]', $mycred_types, $op['disabled_pt'], false, false, '<div class="clear"></div>' ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'If you wish to disable rewarding for some particular point type for this form, then please check it here.', 'ipt_fsqm_mc' ) ); ?>
			</td>
		</tr>
	</tbody>
</table>
		<?php
	}
}
