<?php
/**
 * IPT FSQM MC Install
 * The library of all the installation class
 *
 * @author Swashata <swashata4u@gmail.com>
 * @package myCRED integration for eForm
 * @subpackage Installation
 */

class IPT_FSQM_MC_Install {

	/**
	 * Database prefix
	 * Mainly used for MS compatibility
	 *
	 * @var string
	 */
	public $prefix;

	public $install_msg;

	public function __construct() {
		global $wpdb;
		$prefix = '';
		$prefix = $wpdb->prefix;

		$this->prefix = $prefix;
	}

	/**
	 * install
	 * Do the things
	 */
	public function install( $networkwide = false ) {
		$this->install_msg = $this->check_compatibility();
		if ( $networkwide == true ) {
			$this->install_msg[] = __( 'This plugin can not be network activated.', 'ipt_fsqm_mc' );
		}
		if ( ! empty( $this->install_msg ) ) {
			deactivate_plugins( plugin_basename( IPT_FSQM_MC_Loader::$abs_file ) );
			wp_die( $this->incompat_notice(), __( 'Can not install myCRED integration for eForm', 'ipt_fsqm_mc' ), array(
				'back_link' => true,
			) );
		}
		$this->checkop();
	}

	public function master_reset() {
		$this->restore_op();
	}

	/**
	 * Restores the WP Options to the defaults
	 * Deletes the default options set and calls checkop
	 */
	public function restore_op() {
		delete_option( 'ipt_fsqm_mc_info' );

		$this->checkop();
	}

	public function incompat_notice() {
		return implode( '<br />', (array) $this->install_msg );
	}

	/**
	 * Checks whether PHP version 5 or greater is installed or not
	 * Also checks whether WordPress version is greater than or equal to the required
	 *
	 * If fails then it automatically deactivates the plugin
	 * and gives error
	 *
	 * @return void
	 */
	public function check_compatibility() {
		$msgs = array();
		if ( !class_exists( 'IPT_FSQM_Loader' ) ) {
			$msgs[] = __( 'mCRED integration for eForm addon requires <strong>eForm - WordPress Form Builder</strong> to be installed and activated.', 'ipt_fsqm_mc' );
		}
		if ( version_compare( PHP_VERSION, '5.3.0', '<' ) ) {
			$msgs[] = __( 'mCRED integration for eForm addon requires PHP version greater than or equal to 5.3.x', 'ipt_fsqm_mc' );
		}
		if ( class_exists( 'IPT_FSQM_Loader' ) && version_compare( IPT_FSQM_Loader::$version, '3.0.0', '<' ) ) {
			$msgs[] = __('mCRED integration for eForm addon requires eForm Version 3.0.0 or greater.', 'ipt_fsqm_mc' );
		}
		return $msgs;
	}

	/**
	 * Creates the options
	 */
	public function checkop() {
		$prefix = $this->prefix;
		$ipt_fsqm_mc_info = array(
			'version' => IPT_FSQM_MC_Loader::$version,
		);

		if ( ! get_option( 'ipt_fsqm_mc_info', false ) ) {
			// Fresh installation
			add_option( 'ipt_fsqm_mc_info', $ipt_fsqm_mc_info );
		} else {
			// Update
			$old_op = get_option( 'ipt_fsqm_mc_info', array() );
			switch ( $old_op['version'] ) {
				default :
					break;
				case '1.0.0' :
					// Do something
					break;
			}

			// Always parse and update the options
			$info = wp_parse_args( $old_op, $ipt_fsqm_mc_info );

			update_option( 'ipt_fsqm_mc_info', $info );
		}

		set_transient( 'ipt_abbr_flush_rewrite', true );
		global $ipt_fsqm_mc_info;
		$ipt_fsqm_mc_info = get_option( 'ipt_fsqm_mc_info' );
	}
}
