<?php
/**
 * IPT FSQM MC Loader
 * The library of loader class
 *
 * @author Swashata <swashata4u@gmail.com>
 * @package myCRED integration for eForm
 * @subpackage Loader
 */

class IPT_FSQM_MC_Loader {

	/**
	 *
	 *
	 * @staticvar string
	 * Holds the absolute path of the main plugin file directory
	 */
	static $abs_path;

	/**
	 *
	 *
	 * @staticvar string
	 * Holds the absolute path of the main plugin file
	 */
	static $abs_file;

	/**
	 * Holds the text domain
	 * Use the string directly instead
	 * But still set this for some methods, especially the loading of the textdomain
	 */
	static $text_domain;

	/**
	 *
	 *
	 * @staticvar string
	 * The current version of the plugin
	 */
	static $version;

	/**
	 *
	 *
	 * @staticvar string
	 * The abbreviated name of the plugin
	 * Mainly used for the enqueue style and script of the default admin.css and admin.js file
	 */
	static $abbr;

	/**
	 * The Documentation Link - From InTechgrity
	 *
	 * @var string
	 */
	static $documentation;

	/**
	 * The support forum link - From WordPress Extends
	 *
	 * @var string
	 */
	static $support_forum;


	/**
	 * Constructor function
	 *
	 * @global array $ipt_fsqm_mc_info The information option variable
	 * @param type    $file_loc
	 * @param type    $classes
	 * @param type    $text_domain
	 * @param type    $version
	 * @param type    $abbr
	 */
	public function __construct( $file_loc, $text_domain = 'default', $version = '1.0.0', $abbr = '', $doc = '', $sup = '' ) {
		self::$abs_path = dirname( $file_loc );
		self::$abs_file = $file_loc;
		self::$text_domain = $text_domain;
		self::$version = $version;
		self::$abbr = $abbr;
		self::$documentation = $doc;
		self::$support_forum = $sup;
		global $ipt_fsqm_mc_info;
		$ipt_fsqm_mc_info = get_option( 'ipt_fsqm_mc_info' );
	}

	public function load() {
		// activation hook
		register_activation_hook( self::$abs_file, array( $this, 'plugin_install' ) );
		// deactivation hook
		register_deactivation_hook( self::$abs_file, array( $this, 'plugin_deactivate' ) );
		// Load Text Domain For Translations //
		add_action( 'plugins_loaded', array( $this, 'plugin_textdomain' ) );
		// Check for version and database compatibility //
		add_action( 'plugins_loaded', array( $this, 'database_version' ) );

		// Instantiate
		add_action( 'plugins_loaded', array( $this, 'fsqm_init' ) );

		// Add the myCRED hooks
		add_filter( 'mycred_setup_hooks', array( $this, 'fsqm_mycred_hook' ) );
		add_action( 'mycred_load_hooks', array( $this, 'fsqm_mycred_load' ) );

		// Add Badges Hook
		add_action( 'mycred_all_references', array( $this, 'fsqm_mycred_references' ) );
	}

	public function fsqm_init() {
		if ( ! class_exists( 'myCRED_Hook' ) || ! class_exists( 'IPT_FSQM_Loader' ) ) {
			add_filter( 'admin_notices', array( $this, 'fsqm_mycred_notice' ) );
			return;
		}

		// Initiate the fsqm init
		require_once self::$abs_path . '/classes/class-ipt-fsqm-mc-init.php';
		IPT_FSQM_MC_Init::init();
	}

	public function fsqm_mycred_hook( $installed ) {
		$installed['fsqm'] = array(
			'title'       => __( 'Points for eForm submission', 'ipt_fsqm_mc' ),
			'description' => __( 'Award points for submitting eForms. Settings are here are obeyed globally. But you also need to enable myCRED Integration inside every eForm you want to award for. You can also disable awarding for a particular point type from form settings. It can be found under Form Builder > Integration > myCRED.', 'ipt_fsqm_mc' ),
			'callback'    => array( 'IPT_FSQM_MC_Hook' ),
		);
		return $installed;
	}

	public function fsqm_mycred_load() {
		require_once self::$abs_path . '/classes/class-ipt-fsqm-mc-hook.php';
	}

	public function fsqm_mycred_references( $list ) {
		$list['fsqm'] = __( 'eForm Submission ', 'ipt_fsqm_mc' );

		return $list;
	}

	public function fsqm_mycred_notice() {
		if ( ! class_exists( 'IPT_FSQM_Loader' ) ) {
		?>
		<div class="notice notice-warning">
			<p><?php printf( __( '<strong>myCRED Integration for eForm</strong> requires <a href="%1$s">eForm</a> installed and activated.', 'ipt_fsqm_mc' ), 'https://codecanyon.net/item/eform-wordpress-form-builder/3180835' ); ?></p>
		</div>
		<?php
		}
		if ( ! class_exists( 'myCRED_Hook' ) ) {
			$mycred_dir = 'mycred/mycred.php';
			$installation_url =  wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=' . dirname( $mycred_dir ) ), 'install-plugin_' . dirname( $mycred_dir ) );
			// Check if plugin is installed but not activated
			if ( is_dir( dirname( WP_PLUGIN_DIR . '/' . $mycred_dir ) ) && is_plugin_inactive( $mycred_dir ) ) {
				$installation_url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $mycred_dir, 'activate-plugin_' . $mycred_dir );
			}

		?>
		<div class="notice notice-warning">
			<p><?php printf( __( '<strong>myCRED Integration for eForm</strong> requires <a href="%1$s">myCRED Plugin</a> installed and activated.', 'ipt_fsqm_mc' ), $installation_url ); ?></p>
		</div>
		<?php
		}
	}

	public function plugin_install( $networkwide = false ) {
		require_once self::$abs_path . '/classes/class-ipt-fsqm-mc-install.php';

		$install = new IPT_FSQM_MC_Install();
		$install->install( $networkwide );
	}

	public function plugin_deactivate() {

	}

	public function database_version() {
		global $ipt_fsqm_mc_info;
		$d_version = $ipt_fsqm_mc_info['version'];
		$s_version = self::$version;

		if ( version_compare( $d_version, $s_version, '<' ) ) {
			require_once self::$abs_path . '/classes/class-ipt-fsqm-mc-install.php';

			$install = new IPT_FSQM_MC_Install();
			$install->checkop();
		}
	}

	/**
	 * Load the text domain on plugin load
	 * Hooked to the plugins_loaded via the load method
	 *
	 * dirname( plugin_basename( self::$abs_file ) )
	 */
	public function plugin_textdomain() {
		load_plugin_textdomain( 'ipt_fsqm_mc', false, basename( dirname( self::$abs_file ) ) . '/translations' );
	}
}
