<?php
/**
 * IPT EXP_SQL Admin
 * The library of all the administration classes
 *
 * @author Swashata <swashata4u@gmail.com>
 * @package Plugin
 * @subpackage Admin Backend classes
 */

/*==============================================================================
 * Admin Classes
 *============================================================================*/
/**
 * Dashboard class
 */
class IPT_EXP_SQL_Check_Form extends IPT_FSQM_Admin_Base {
	public $table_view;
	public $direct_table_info;
	public function __construct() {
		$this->capability = 'manage_feedback';
		$this->action_nonce = 'ipt_exp_sql_check_form_nonce';
		$this->is_metabox = false;

		parent::__construct();

		$this->icon = 'stack';

		$this->post_result[4] = array(
			'type' => 'update',
			'msg' => __( 'Successfully deleted the export', 'ipt_exp_sql' ),
		);
		$this->post_result[5] = array(
			'type' => 'error',
			'msg' => __( 'Could not perform the action. Invalid action and/or nonce', 'ipt_exp_sql' ),
		);
		$this->post_result[6] = array(
			'type' => 'update',
			'msg' => __( 'Successfully deleted the exports', 'ipt_exp_sql' ),
		);

		// Add admin ajax stuff
		add_action( 'wp_ajax_ipt_exp_sql_cms_ajax', array( $this, 'ajax_cms' ) );
		add_action( 'wp_ajax_ipt_exp_sql_xlsx_download', array( $this, 'download_xlsx' ) );
		add_action( 'wp_ajax_ipt_fsqm_exp_revisionview', array( $this, 'ajax_revision_view' ) );
	}

	/*==========================================================================
	 * SYSTEM METHODS
	 *========================================================================*/

	public function admin_menu() {
		$this->pagehook = add_submenu_page( 'ipt_fsqm_dashboard', __( 'Check Form Auto Exports', 'ipt_exp_sql' ), __( 'Form Auto Exports', 'ipt_exp_sql' ), $this->capability, 'ipt_exp_sql_check_form', array( $this, 'index' ) );
		parent::admin_menu();
	}

	public function index() {
		global $ipt_exp_sql_info, $wpdb;

		$page_action = isset( $_GET['exp_action'] ) ? $_GET['exp_action'] : 'none';

		if ( $page_action == 'cms' ) {
			$this->index_head( __( 'eForm - Easy SQL <span class="ipt-icomoon-arrow-right2"></span> Check Form Auto Exports', 'ipt_exp_sql' ), false );
			$this->generate_checker();
		} elseif ( $page_action == 'view' ) {
			$this->index_head( sprintf( __( 'eForm - Easy SQL <span class="ipt-icomoon-arrow-right2"></span> Browse Form Auto Exports <a href="%1$s" class="add-new-h2">Check Exports</a>', 'ipt_exp_sql' ), 'admin.php?page=ipt_exp_sql_check_form&exp_action=cms&form_id=' . @$_GET['form_id'] ), false );
			$this->browse_table();
		} else {
			$forms = IPT_FSQM_Form_Elements_Static::get_forms();
			$form_items = array();
			foreach ( $forms as $form ) {
				// Check if table is there
				$table_name = $wpdb->prefix . 'fsqm_direct_' . $form->id;
				if ( $wpdb->get_var( "SHOW TABLES LIKE '{$table_name}'" ) == $table_name ) {
					$form_items[] = array(
						'label' => $form->name,
						'value' => $form->id,
					);
				}
			}
			$this->index_head( __( 'eForm - Easy SQL <span class="ipt-icomoon-arrow-right2"></span> Auto Exports Operations', 'ipt_exp_sql' ), false );
		?>
<form action="" method="GET">
<input type="hidden" value="ipt_exp_sql_check_form" name="page" />
<div class="ipt_uif_iconbox ipt_uif_shadow glowy">
	<div class="ipt_uif_box cyan">
		<h3><span class="ipt-icomoon-cog"></span><?php _e( 'Check Form SQL Status', 'ipt_fsqm' ); ?></h3>
	</div>
	<div class="ipt_uif_iconbox_inner">
		<table class="form-table">
			<tbody>
				<tr>
					<th><?php $this->ui->generate_label( 'form_id', __( 'Select Form', 'ipt_exp_sql' ) ); ?></th>
					<td>
						<?php $this->ui->select( 'form_id', $form_items, '' ); ?>
					</td>
				</tr>
			</tbody>
		</table>
		<div class="ipt_uif_button_container">
			<button class="ipt_uif_button large primary-button" type="submit" name="exp_action" value="cms"><?php _e( 'Synchronize Submissions', 'ipt_exp_sql' ); ?></button>
			<button class="ipt_uif_button large primary-button" type="submit" name="exp_action" value="view"><?php _e( 'View Exports', 'ipt_exp_sql' ); ?></button>
			<button class="ipt_uif_button large primary-button" id="ipt_exp_sql_xlsx_download_b" type="button" value="xlsx"><?php _e( 'Download Exports (XLSX)', 'ipt_exp_sql' ); ?></button>
			<?php $this->ui->clear(); ?>
		</div>
	</div>
</div>
<p><span class="description"><?php printf( __( 'eForm - Easy SQL :: Version <code>%1$s</code> (Script) / <code>%2$s</code> (DB).', 'ipt_exp_sql' ), $ipt_exp_sql_info['version'], IPT_EXP_SQL_Loader::$version ) ?></span></p>
</form>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		var _wpnonce = '<?php echo wp_create_nonce( 'ipt_exp_sql_xlsx' ); ?>';
		$('#ipt_exp_sql_xlsx_download_b').on('click', function(e) {
			e.preventDefault();
			var form_id = $('#form_id').val();
			window.open( ajaxurl + '?action=ipt_exp_sql_xlsx_download&_wpnonce=' + _wpnonce + '&form_id=' + form_id, '_blank' );
			return false;
		});
	});
</script>
		<?php
		}
		$this->index_foot( false );
	}

	public function generate_checker() {
		$form_id = isset( $_GET['form_id'] ) ? (int) $_GET['form_id'] : 0;
		$form = new IPT_FSQM_Form_Elements_Base( $form_id );
		// Check if valid form
		if ( $form->form_id == null ) {
			$this->ui->msg_error( __( 'Invalid Form', 'ipt_exp_sql' ) );
			return;
		}

		// Check if settings permit
		if ( $form->settings['direct_exp']['enabled'] != true ) {
			$this->ui->msg_error( __( 'Form does not have export to sql active.', 'ipt_exp_sql' ) );
			return;
		}

		// Everything set, now initiate the ajax
		printf( '<h3>%1$s</h3><br /><br />', sprintf( __( 'Checking form <code>%1$s</code> and related table for missing or expired records.', 'ipt_exp_sql' ), $form->name ) );
		$this->ui->progressbar( 'ipt_exp_sql_pb', 0 );
		$this->ui->ajax_loader( false, 'ipt_exp_sql_al', array(), true, __( 'Working', 'ipt_exp_sql' ) );
		?>
<div id="ipt_exp_sql_okay" style="display: none;">
	<?php $this->ui->msg_okay( sprintf( __( 'All Set. You may browse the exports from <a href="%1$s">here</a>.', 'ipt_exp_sql' ), 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=' . $form_id ) ); ?>
</div>
<div id="ipt_exp_sql_error" style="display: none;">
	<?php $this->ui->msg_error( __( 'An error has occured.', 'ipt_exp_sql' ) ); ?>
</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		var data = {
			form_id: <?php echo $form->form_id ?>,
			_wpnonce: '<?php echo wp_create_nonce( 'ipt_exp_sql_cms_' . $form->form_id ); ?>',
			count: 0,
			action: 'ipt_exp_sql_cms_ajax'
		},
		pb = $('#ipt_exp_sql_pb'),
		al = $('#ipt_exp_sql_al'),
		okay = $('#ipt_exp_sql_okay'),
		error = $('#ipt_exp_sql_error');

		function expSQLAJAX( data ) {
			$.ajax({
				url: ajaxurl,
				type: 'GET',
				dataType: 'json',
				data: data,
			})
			.done(function( response, textStatus, jqXHR ) {
				if ( response.status == 'fail' ) {
					error.fadeIn('fast').find('p').html( response.error );
					al.hide();
					pb.hide();
				} else {
					pb.progressbar('option', 'value', response.percentage);
					if ( response.done == 0 ) {
						data.count = response.count;
						expSQLAJAX( data );
					} else {
						al.hide();
						pb.hide();
						okay.fadeIn('fast');
					}
				}
			})
			.fail(function( jqXHR, textStatus, errorThrown ) {
				error.fadeIn('fast').find('p').html( textStatus + ' ' + errorThrown );
				al.hide();
				pb.hide();
			});
		}
		expSQLAJAX( data );
	});
</script>
		<?php
	}

	public function ajax_revision_view() {
		if ( ! current_user_can( 'manage_feedback' ) ) {
			die( __( 'Cheatin&#8217; uh?' ) );
		}

		global $wpdb;

		// Get the ID
		$data_id = (int) @$_GET['data_id'];

		// Create the object
		require_once IPT_EXP_SQL_Loader::$abs_path . '/classes/class-ipt-fsqm-form-elements-sql.php';
		$exp_sql = new IPT_FSQM_Form_Elements_SQL( $data_id );

		if ( null == $exp_sql->data_id ) {
			die( __( 'Invalid ID', 'ipt_exp_sql' ) );
		}

		// All set, now just show
		$rev_data = $exp_sql->get_revisions();
		$table_data = $exp_sql->get_table_info();
		$blacklists = array( 'id', 'updated', 'form_id', 'data_id', 'ref' );
		?>
<table class="ipt_fsqm_preview">
	<thead>
		<tr>
			<th><?php _e( 'Submission Time<br />/<br />Elements', 'ipt_exp_sql' ); ?></th>
			<th><?php echo $rev_data['current']['updated']; ?></th>
			<?php foreach ( $rev_data['revisions'] as $rev ) : ?>
				<th><?php echo $rev['updated']; ?></th>
			<?php endforeach; ?>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<th><?php _e( 'Submission Time', 'ipt_exp_sql' ); ?></th>
			<th><?php echo $rev_data['current']['updated']; ?></th>
			<?php foreach ( $rev_data['revisions'] as $rev ) : ?>
				<th><?php echo $rev['updated']; ?></th>
			<?php endforeach; ?>
		</tr>
	</tfoot>
	<tbody>
		<?php foreach ( $table_data as $tdata ) : ?>
			<?php if ( in_array( $tdata->Field, $blacklists ) ) : ?>
				<?php continue; ?>
			<?php endif; ?>
			<tr>
				<th><?php echo $tdata->Comment; ?><br /><span class="description"><?php echo $tdata->Field; ?></span></th>
				<td><pre style="overflow: auto; max-width: 100px; max-height: 100px;"><?php echo $rev_data['current'][ $tdata->Field ]; ?></pre></td>
				<?php foreach ( $rev_data['revisions'] as $rev ) : ?>
					<td><pre style="overflow: auto; max-width: 100px; max-height: 100px;"><?php echo $rev[ $tdata->Field ]; ?></pre></td>
				<?php endforeach; ?>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>
		<?php
		die();
	}

	public function ajax_cms() {
		if ( ! current_user_can( 'manage_feedback' ) ) {
			die( __( 'Cheatin&#8217; uh?' ) );
		}

		// Globals
		global $wpdb, $ipt_fsqm_info;

		// Set the header
		@header( 'Content-Type: application/json; charset=' . get_option( 'blog_charset' ) );

		// Get the variables
		$form_id = isset( $_GET['form_id'] ) ? (int) $_GET['form_id'] : 0;
		$wpnonce = isset( $_GET['_wpnonce'] ) ? $_GET['_wpnonce'] : '';
		$count = isset( $_GET['count'] ) ? (int) $_GET['count'] : 0;

		// Initialize the return
		$return = array(
			'status' => 'fail',
			'error' => '',
		);

		// Verify nonce
		if ( ! wp_verify_nonce( $wpnonce, 'ipt_exp_sql_cms_' . $form_id ) ) {
			$return['error'] = __( 'Invalid Nonce.', 'ipt_exp_sql' );
			echo json_encode( $return );
			die();
		}

		// Check if form exists
		$form = new IPT_FSQM_Form_Elements_Base( $form_id );
		if ( $form->form_id == null ) {
			$return['error'] = __( 'Invalid Form ID.', 'ipt_exp_sql' );
			echo json_encode( $return );
			die();
		}

		// Check if settings permits
		if ( $form->settings['direct_exp']['enabled'] != true ) {
			$return['error'] = __( 'Export to SQL not active.', 'ipt_exp_sql' );
			echo json_encode( $return );
			die();
		}

		// Prepare Limits
		// and check if data exists
		$total_data = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(id) FROM {$ipt_fsqm_info['data_table']} WHERE form_id = %d", $form->form_id ) );

		if ( ! $total_data ) {
			$return['error'] = __( 'No Submissions yet', 'ipt_exp_sql' );
			echo json_encode( $return );
			die();
		}

		$perpage = 20;
		$limit = " LIMIT " . ( $count * $perpage ) . "," . $perpage;

		// Now prepare the query
		$exp_table = $wpdb->prefix . 'fsqm_direct_' . $form->form_id;
		$query = "SELECT d.id data_id, d.date updated, e.id eid, e.updated eupdated FROM {$ipt_fsqm_info['data_table']} d LEFT JOIN {$exp_table} e ON d.id = e.data_id WHERE d.form_id = " . $form->form_id;
		$query .= " ORDER BY data_id DESC";
		$query .= " " . $limit;

		// Get datas
		$data_rows = $wpdb->get_results( $query );
		if ( empty( $data_rows ) ) {
			$return['status'] = 'success';
			$return['count'] = $count + 1;
			$return['percentage'] = 100;
			echo json_encode( $return );
			die();
		}

		$return['updated'] = array();
		$return['notupdated'] = array();

		// Now do the magic
		require_once IPT_EXP_SQL_Loader::$abs_path . '/classes/class-ipt-fsqm-form-elements-sql.php';
		foreach ( $data_rows as $data ) {
			if ( ! $data->eid || $data->updated != $data->eupdated ) {
				$data_exp = new IPT_FSQM_Form_Elements_SQL( $data->data_id );
				$data_exp->save_to_table();
				$return['updated'][] = $data->data_id;
			} else {
				$return['notupdated'][] = $data->data_id;
			}
		}

		// Prepare the return
		$return['status'] = 'success';
		$return['count'] = $count + 1;
		$return['percentage'] = round( ( $perpage * ( $count + 1 ) / $total_data ) * 100, 2 );
		if ( $return['percentage'] > 100 ) {
			$return['percentage'] = 100;
		}
		$return['done'] = ( $return['percentage'] >= 100 ? 1 : 0 );

		// In the end check for limitation
		if ( $return['percentage'] >= 100 && is_object( $data ) ) {
			$dummy_exp = new IPT_FSQM_Form_Elements_SQL( $data->data_id );
			$dummy_exp->check_limitation();
		}

		echo json_encode( $return );
		die();
	}

	public function browse_table() {
		if ( null == $this->direct_table_info ) {
			$this->ui->msg_error( __( 'Form does not have export to sql active.', 'ipt_exp_sql' ) );
		}
		$this->table_view->prepare_items();
		?>
		<style type="text/css">
		.ipt_uif_iconbox_inner td,
		.ipt_uif_iconbox_inner th {
			font-size: 10px;
			width: 100px;
		}
		.ipt_fsqm_direct_tables .column-name {
			width: 200px;
			font-size: 14px;
		}
		</style>
		<div class="ipt_uif_iconbox ipt_uif_shadow glowy">
			<div class="ipt_uif_box cyan">
				<h3><span class="ipt-icomoon-pencil"></span><?php _e( 'View or Delete Exports', 'ipt_exp_sql' ); ?></h3>
			</div>
			<div class="ipt_uif_iconbox_inner" style="overflow-x: auto;">
				<form action="" method="get">
					<?php foreach ( $_GET as $k => $v ) : if ( $k == 'order' || $k == 'orderby' || $k == 'page' || $k == 'form_id' || $k == 'exp_action' ) : ?>
					<input type="hidden" name="<?php echo $k; ?>" value="<?php echo $v; ?>" />
					<?php endif; endforeach; ?>
					<?php $this->table_view->search_box( __( 'Search Submissions', 'ipt_exp_sql' ), 'search_id' ); ?>
					<?php $this->table_view->display(); ?>
				</form>
			</div>
		</div>
		<?php
	}

	public function download_xlsx() {
		if ( ! current_user_can( 'manage_feedback' ) ) {
			die( __( 'Cheatin&#8217; uh?' ) );
		}

		// Get the form ID
		$form_id = isset( $_GET['form_id'] ) ? (int) $_GET['form_id'] : 0;
		if ( 0 == $form_id ) {
			wp_die( __( 'Invalid Form ID', 'ipt_exp_sql' ), __( 'An error has occured', 'ipt_exp_sql' ) );
		}

		// Check form integrity
		$form = new IPT_FSQM_Form_Elements_Base( $form_id );
		if ( $form->form_id == null ) {
			wp_die( __( 'Form not found', 'ipt_exp_sql' ), __( 'An error has occured', 'ipt_exp_sql' ) );
		}

		// Check if settings allows
		if ( $form->settings['direct_exp']['enabled'] != true ) {
			wp_die( __( 'Export to SQL not active.', 'ipt_exp_sql' ), __( 'An error has occured', 'ipt_exp_sql' ) );
		}

		// Verify nonce
		if ( ! wp_verify_nonce( $_GET['_wpnonce'], 'ipt_exp_sql_xlsx' ) ) {
			wp_die( __( 'Cheatin&#8217; uh?' ) );
		}

		// All set now export
		global $wpdb, $ipt_fsqm_info;
		$table_name = $wpdb->prefix . 'fsqm_direct_' . $form_id;
		$table_info = $wpdb->get_results( "SHOW FULL COLUMNS FROM {$table_name}" );
		// process the table info
		if ( ! empty ( $table_info ) ) {
			require_once IPT_EXP_SQL_Loader::$abs_path . '/classes/xlsxwriter.class.php';
			ini_set('display_errors', 0);
			ini_set('log_errors', 1);
			error_reporting(E_ALL & ~E_NOTICE);

			$filename = "{$table_name}.xlsx";
			header( 'Content-disposition: attachment; filename="' . XLSXWriter::sanitize_filename( $filename ) . '"' );
			header( "Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" );
			header( 'Content-Transfer-Encoding: binary' );
			header( 'Cache-Control: must-revalidate' );
			header( 'Pragma: public' );

			$writer = new XLSXWriter();
			$writer->setAuthor( 'eForm' );

			$direct_table_info = array(
				__( 'ID', 'ipt_exp_sql' ),
				__( 'Name', 'ipt_exp_sql' ),
				__( 'Submission Date', 'ipt_exp_sql' ),
				__( 'Email', 'ipt_exp_sql' ),
				__( 'Phone', 'ipt_exp_sql' ),
				__( 'IP', 'ipt_exp_sql' ),
				__( 'Score', 'ipt_exp_sql' ),
				__( 'Max Score', 'ipt_exp_sql' ),
				__( 'Referer', 'ipt_exp_sql' ),
				__( 'URL Track', 'ipt_exp_sql' ),
				__( 'Time', 'ipt_exp_sql' ),
			);
			$direct_table_key = array(
				'updated', 'email', 'phone', 'ip', 'score', 'max_score', 'referer', 'url_track', 'ctime'
			);
			$column_exclusions = array( 'id', 'data_id', 'updated', 'form_id', 'ref' );
			foreach ( $table_info as $column ) {
				if ( ! in_array( $column->Field, $column_exclusions ) ) {
					$direct_table_info[] = $column->Comment . ' - ' . $column->Field;
					$direct_table_key[] = $column->Field;
				}
			}
			$direct_table_info[] = __( 'Link', 'ipt_exp_sql' );
			$direct_table_key[] = 'link';

			// Add the first row
			$writer->writeSheetRow( 'Sheet1', $direct_table_info );

			// Add actual data
			$query = "SELECT e.*, d.f_name f_name, d.l_name l_name, d.email email, d.phone phone, d.ip ip, d.score score, d.max_score max_score, d.user_id user_id, d.referer referer, d.url_track url_track, d.time ctime, ( SELECT COUNT( id ) FROM {$table_name} r WHERE r.ref = e.id ) AS revision FROM {$table_name} e LEFT JOIN {$ipt_fsqm_info['data_table']} d ON e.data_id = d.id WHERE e.ref = 0 ORDER BY id DESC";
			$data_rows = $wpdb->get_results( $query );
			if ( $data_rows ) {
				foreach ( $data_rows as $data ) {
					$data->link = admin_url( 'admin.php?page=ipt_fsqm_view_submission&id=' . $data->data_id );
					$row = array();
					$row[] = $data->id;
					$row[] = $data->f_name . ' ' . $data->l_name;
					foreach ( $direct_table_key as $key ) {
						$row[] = $data->{$key};
					}
					$writer->writeSheetRow( 'Sheet1', $row );
					// Now check if any revisions are present
					if ( $data->revision > 0 ) {
						// Get the revisions
						$revisions = (array) $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} WHERE ref = %d ORDER BY id DESC", $data->id ) );
						foreach ( $revisions as $rev ) {
							$rev_row = array();
							$rev_row[] = $rev->id;
							$rev_row[] = sprintf( __( 'Revision for %d', 'ipt_exp_sql' ), $data->id );
							foreach ( $direct_table_key as $key ) {
								if ( 'updated' == $key ) {
									$rev_row[] = $rev->updated;
								} else if ( in_array( $key, array( 'email', 'phone', 'ip', 'score', 'max_score' ) ) ) {
									$rev_row[] = '';
								} else {
									$rev_row[] = $rev->{$key};
								}
							}
							$writer->writeSheetRow( 'Sheet1', $rev_row );
						}
					}
				}
			} else {
				$writer->writeSheetRow( 'Sheet1', array( __( 'Some error occured. Could not fetch data from database. Please check the query.', 'ipt_exp_sql' ) ) );
				$writer->writeSheetRow( 'Sheet1', array( $query ) );
			}

			$writer->writeToStdOut();
		} else {
			wp_die( __( 'Export table does not exist. Either form has no submission or please check for missing submissions by going back.', 'ipt_exp_sql' ), __( 'An error has occured', 'ipt_exp_sql' ) );
		}

		die();
	}

	public function on_load_page() {
		// Prepare the table view if necessary
		$page_action = isset( $_GET['exp_action'] ) ? $_GET['exp_action'] : 'none';
		if ( $page_action == 'view' ) {
			$option = 'per_page';
			$args = array(
				'label' => __( 'Data per page', 'ipt_exp_sql' ),
				'default' => 20,
				'option' => 'exp_sqls_per_page',
			);
			add_screen_option( $option, $args );
			$form_id = isset( $_GET['form_id'] ) ? (int) $_GET['form_id'] : 0;
			global $wpdb;
			$table_name = $wpdb->prefix . 'fsqm_direct_' . $form_id;
			$table_info = $wpdb->get_results( "SHOW FULL COLUMNS FROM {$table_name}" );
			// $this->direct_table_info = $table_info;
			// process the table info
			if ( ! empty ( $table_info ) ) {
				$this->direct_table_info = array();
				$this->direct_table_info['table_name'] = $table_name;
				$this->direct_table_info['columns'] = array(
					'cb' => '<input type="checkbox" />',
					'name' => __( 'Name', 'ipt_exp_sql' ),
					'updated' => __( 'Submission Date', 'ipt_exp_sql' ),
					'email' => __( 'Email', 'ipt_exp_sql' ),
					'phone' => __( 'Phone', 'ipt_exp_sql' ),
					'ip' => __( 'IP', 'ipt_exp_sql' ),
					'score' => __( 'Score', 'ipt_exp_sql' ),
					'max_score' => __( 'Max Score', 'ipt_exp_sql' ),
				);
				$this->direct_table_info['sortables'] = array(
					'name' => array( 'd.f_name', false ),
					'updated' => array( 'updated', true ),
					'email' => array( 'd.email', false ),
					'phone' => array( 'd.phone', false ),
					'ip' => array( 'd.ip', false ),
					'score' => array( 'd.score', true ),
					'max_score' => array( 'd.max_score', true ),
				);
				$this->direct_table_info['search_cols'] = array(
					'd.email', 'd.phone', 'd.ip', 'd.score', 'd.max_score',
				);
				$column_exclusions = array( 'id', 'data_id', 'updated', 'form_id' );
				foreach ( $table_info as $column ) {
					if ( ! in_array( $column->Field, $column_exclusions ) ) {
						$this->direct_table_info['columns'][$column->Field] = '<span style="font-size: 12px">' . $column->Comment . '</span><br /><code style="font-size: 10px;">' . $column->Field . '</code>';
						$this->direct_table_info['sortables'][$column->Field] = array( 'e.' . $column->Field, false );
						$this->direct_table_info['search_cols'][] = 'e.' . $column->Field;
					}
				}
			}
			$this->table_view = new IPT_FSQM_Direct_List_Table( $this->direct_table_info );

			$table_action = $this->table_view->current_action();

			if ( false !== $table_action ) {
				// If single delete request
				if ( $table_action == 'delete' ) {
					if ( isset( $_GET['id'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'ipt_fsqm_exp_delete_' . $_GET['id'] ) ) {
						if ( $wpdb->query( $wpdb->prepare( "DELETE FROM {$table_name} WHERE id = %d", $_GET['id'] ) ) ) {
							wp_redirect( add_query_arg( array( 'post_result' => 4 ), sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s', $_GET['form_id'], $this->table_view->get_pagenum() ) ) );
						} else {
							wp_redirect( add_query_arg( array( 'post_result' => 5 ), sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s', $_GET['form_id'], $this->table_view->get_pagenum() ) ) );
						}
					}
				// If bulk delete request
				} elseif ( $table_action == 'bdelete' ) {
					$ids = $_GET['exports'];
					$ids = array_map( 'intval', (array) $ids );
					$ids = implode( ',', (array) $ids );
					if ( $ids != '' && wp_verify_nonce( $_GET['_wpnonce'], 'bulk-ipt_fsqm_direct_tables' ) ) {
						if ( $wpdb->query( "DELETE FROM {$table_name} WHERE id IN ({$ids})" ) ) {
							wp_redirect( add_query_arg( array( 'post_result' => 6 ), sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s', $_GET['form_id'], $this->table_view->get_pagenum() ) ) );
						} else {
							wp_redirect( add_query_arg( array( 'post_result' => 5 ), sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s', $_GET['form_id'], $this->table_view->get_pagenum() ) ) );
						}
					} else {
						wp_redirect( add_query_arg( array( 'post_result' => 5 ), sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s', $_GET['form_id'], $this->table_view->get_pagenum() ) ) );
					}
				}
			}
		}
		parent::on_load_page();

		get_current_screen()->add_help_tab( array(
			'id' => 'overview',
			'title' => __( 'Overview', 'ipt_exp_sql' ),
			'content' =>
			'<p>' . __( 'Thank you for using Easy SQL Plugin for eForm. This addon helps export form submissions directly to a database table for your ease.', 'ipt_exp_sql' ) . '<p>' .
			'<p>' . __( 'The concept and working of the addon is very simple.', 'ipt_exp_sql' ) . '</p>' .
			'<ul>' .
			'<li>' . __( 'You setup a form from the <a href="admin.php?page=ipt_exp_sql_new_form">New Form</a> or edit an <a href="admin.php?page=ipt_fsqm_all_forms">Existing Form</a>.', 'ipt_exp_sql' ) . '</li>' .
			'<li>' . __( 'Under <strong>SQL Export</strong> you enable the settings and put in configuration values.', 'ipt_exp_sql' ) . '</li>' .
			'<li>' . __( 'Once being activated, the system will automatically start saving the submissions to the corresponding table.', 'ipt_exp_sql' ) . '</li>' .
			'</ul>' .
			'<p>' . __( 'If you have submissions existing prior installation of this addon, then you can generate the sql exports manually. To do so, you will find the necessary tools in this page.', 'ipt_exp_sql' ) . '</p>' .
			'<p>' . __( 'If you have any suggestions or have encountered any bug, please feel free to use the Linked support forum', 'ipt_exp_sql' ) . '</p>',
		) );

		get_current_screen()->add_help_tab( array(
			'id' => 'tools',
			'title' => __( 'Actions and Tools', 'ipt_exp_sql' ),
			'content' =>
			'<p>' . __( 'This page has the following actions and tools.', 'ipt_exp_sql' ) . '</p>' .
			'<ul>' .
			'<li>' . __( '<code>Synchronize Submissions</code> : Will loop through all submissions of the form and will export to SQL if the entry is not present or has been changed. Will also drop expired and/or irrelevant records.', 'ipt_exp_sql' ) . '</li>' .
			'<li>' . __( '<code>View Exports</code> : You can browse through all exports of a form and perform bulk deletion.', 'ipt_exp_sql' ) . '</li>' .
			'<li>' . __( '<code>Export to XLSX</code> : Create an XLSX file on the fly using a very lightweight engine. You can increase php timeout and memory if it fails.', 'ipt_exp_sql' ) . '</li>' .
			'</ul>' .
			'<p>' . __( 'That is it. Have fun.', 'ipt_exp_sql' ) . '</p>',
		) );

		get_current_screen()->add_help_tab( array(
			'id' => 'credits',
			'title' => __( 'Credits', 'ipt_exp_sql' ),
			'content' =>
			'<p>' . __( 'The plugin uses a few free and/or open source products, which are:', 'ipt_exp_sql' ) .
			'<ul>' .
			'<li>' . __( '<strong><a href="https://github.com/mk-j/PHP_XLSXWriter">PHP_XLSXWriter</a></strong> : Lightwight XLSX Excel Spreadsheet Writer in PHP.', 'ipt_exp_sql' ) . '</li>' .
			'</ul>',
		) );

		get_current_screen()->set_help_sidebar(
			'<p><strong>' . __( 'For more information:', 'ipt_exp_sql' ) . '</strong></p>' .
			'<p>' . sprintf( __( '<a href="%s" target="_blank">Documentation</a>', 'ipt_exp_sql' ), IPT_EXP_SQL_Loader::$documentation ) . '</p>' .
			'<p>' . sprintf( __( '<a href="%s" target="_blank">Support Forums</a>', 'ipt_exp_sql' ), IPT_EXP_SQL_Loader::$support_forum ) . '</p>'
		);
	}
}

/*==============================================================================
 * List Tables
 *============================================================================*/
/**
 * Get the WP_List_Table for populating our table
 */
if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class IPT_FSQM_Direct_List_Table extends WP_List_Table {
	public $form_id;
	public $form_settings;
	public $exp_query;

	public function __construct( $settings = array() ) {
		$this->form_settings = $settings;
		parent::__construct( array(
			'singular' => 'ipt_fsqm_direct_table',
			'plural' => 'ipt_fsqm_direct_tables',
			'ajax' => false,
		) );
	}

	public function get_columns() {
		$columns = $this->form_settings['columns'];
		return $columns;
	}

	public function get_sortable_columns() {
		$sortable = $this->form_settings['sortables'];
		return $sortable;
	}

	public function column_default( $item, $column_name ) {
		global $wpdb;
		switch ( $column_name ) {
			case 'name' :
				$name = ucfirst( $item['f_name'] ) . ' ' . ucfirst( $item['l_name'] );
				$actions = array(
					'qview' => sprintf( '<a class="thickbox" title="%s" href="admin-ajax.php?action=ipt_fsqm_quick_preview&id=%d&width=640&height=500">%s</a>', esc_attr( sprintf( __( 'Submission of %s', 'ipt_fsqm' ), $item['f_name'] . ' ' . $item['l_name'] ) ), $item['data_id'], __( 'Quick Preview', 'ipt_fsqm' ) ),
				);
				// Check if revision exists
				// If so, then modify the name and actions accordingly
				if ( $item['revision'] > 0 ) {
					$name .= ' ' . sprintf( _n( '[%d Revision]', '[%d Revisions]', $item['revision'], 'ipt_exp_sql' ), $item['revision'] );
					$actions['rview'] = sprintf( '<a class="thickbox" title="%s" href="admin-ajax.php?action=ipt_fsqm_exp_revisionview&data_id=%d&width=640&height=500">%s</a>', esc_attr__( 'View and compare all revisions', 'ipt_exp_sql' ), $item['data_id'], __( 'Revisions', 'ipt_exp_sql' ) );
				}
				// Finalize the actions
				$actions['view'] = sprintf( '<a target="_blank" href="admin.php?page=ipt_fsqm_view_submission&id=%d">%s</a>', (int) $item['data_id'], __( 'Full View', 'ipt_fsqm' ) );
				$actions['edit'] = '<a target="_blank" class="edit" href="admin.php?page=ipt_fsqm_view_submission&id=' . $item['data_id'] . '&edit=Edit">' . __( 'Edit Submission', 'ipt_fsqm' ) . '</a>';
				$actions['delete'] = '<a class="delete" href="' . wp_nonce_url( sprintf( 'admin.php?page=ipt_exp_sql_check_form&exp_action=view&form_id=%1$s&paged=%2$s&action=delete&id=' . $item['id'], $_GET['form_id'], $this->get_pagenum() ), 'ipt_fsqm_exp_delete_' . $item['id'], '_wpnonce' ) . '">' . __( 'Delete', 'ipt_exp_sql' ) . '</a>';
				// Create the HTML
				return sprintf( '%1$s %2$s', '<strong><a href="admin-ajax.php?action=ipt_fsqm_quick_preview&id=' . $item['data_id'] . '&width=640&height=640" class="thickbox" title="' . esc_attr( sprintf( __( 'Submission of %s', 'ipt_fsqm' ), $item['f_name'] . ' ' . $item['l_name'] ) ) . '">' . $name . '</a></strong>', $this->row_actions( $actions ) );
				break;
			case 'updated' :
				return date_i18n( get_option( 'date_format' ) . __(' \a\t ', 'ipt_fsqm') . get_option( 'time_format' ), strtotime( $item[$column_name] ) );
				break;
			default :
				return '<pre style="overflow:auto;">' . htmlspecialchars( $item[$column_name] ) . '</pre>';
		}
	}

	public function column_cb( $item ) {
		return sprintf( '<input type="checkbox" name="exports[]" value="%s" />', $item['id'] );
	}

	public function get_bulk_actions() {
		$actions = array(
			'bdelete' => __( 'Delete' ),
		);
		return $actions;
	}

	public function prepare_items() {
		global $wpdb, $ipt_fsqm_info;

		// Prepare our query
		$query = "SELECT e.*, d.f_name f_name, d.l_name l_name, d.email email, d.phone phone, d.ip ip, d.score score, d.max_score max_score, d.user_id user_id, ( SELECT COUNT( id ) FROM {$this->form_settings['table_name']} r WHERE r.ref = e.id ) AS revision FROM {$this->form_settings['table_name']} e LEFT JOIN {$ipt_fsqm_info['data_table']} d ON e.data_id = d.id";
		$orderby = !empty( $_GET['orderby'] ) ? esc_sql( $_GET['orderby'] ) : 'updated';
		$order = !empty( $_GET['order'] ) ? esc_sql( $_GET['order'] ) : 'desc';

		$where = ' WHERE ref = 0';

		if ( ! empty( $_GET['s'] ) ) {
			$search = '\'%' . $_GET['s'] . '%\'';
			$match_columns = implode( ' LIKE %1$s OR ', $this->form_settings['search_cols'] );
			if ( $match_columns != '' ) {
				$match_columns .= ' LIKE %1$s ';
			}

			$where .= sprintf( " AND ( {$match_columns})", $search );
		}

		$query .= $where;

		// Pagination
		$totalitems = $wpdb->get_var( "SELECT COUNT(e.id) FROM {$this->form_settings['table_name']} e LEFT JOIN {$ipt_fsqm_info['data_table']} d ON e.data_id = d.id{$where}" );
		$perpage = $this->get_items_per_page( 'exp_sqls_per_page', 20 );
		$totalpages = ceil( $totalitems/$perpage );

		$this->set_pagination_args( array(
			'total_items' => $totalitems,
			'total_pages' => $totalpages,
			'per_page' => $perpage,
		) );
		$current_page = $this->get_pagenum();

		// Put pagination and order on the query
		$query .= ' ORDER BY ' . $orderby . ' ' . $order . ' LIMIT ' . ( ( $current_page - 1 ) * $perpage ) . ',' . (int) $perpage;

		$this->exp_query = $query;

		// register the columns
		$this->_column_headers = $this->get_column_info();

		// fetch the items
		$this->items = $wpdb->get_results( $query, ARRAY_A );
	}

	public function no_items() {
		_e( 'No direct sql data found for this form.', 'ipt_exp_sql' );
	}

	public function extra_tablenav( $which ) {
		global $wpdb, $ipt_fsqm_info;
		$forms = $wpdb->get_results( "SELECT id, name FROM {$ipt_fsqm_info['form_table']} ORDER by id DESC" );
		$users = $wpdb->get_col( "SELECT distinct user_id FROM {$ipt_fsqm_info['data_table']}" );

		switch ( $which ) {
		case 'top' :
?>
<div class="alignleft actions">
	<select name="form_id">
		<?php if ( null != $forms ) : ?>
		<?php foreach ( $forms as $form ) : ?>
		<option value="<?php echo $form->id; ?>"<?php if ( isset( $_GET['form_id'] ) && $_GET['form_id'] == $form->id ) echo ' selected="selected"'; ?>><?php echo $form->name; ?></option>
		<?php endforeach; ?>
		<?php else : ?>
		<option value=""><?php _e( 'No Forms in the database', 'ipt_fsqm' ); ?></option>
		<?php endif; ?>
	</select>
	<?php submit_button( __( 'Filter' ), 'secondary', false, false, array( 'id' => 'form-query-submit' ) ); ?>
</div>
				<?php
			break;
		case 'bottom' :
			printf( __( 'Following Query was used to fetch the results:<br /><code>%1$s</code>', 'ipt_exp_sql' ), $this->exp_query );
			break;
		}
	}
}
