<?php
/**
 * IPT EXP_SQL Install
 * The library of all the installation class
 *
 * @author Swashata <swashata4u@gmail.com>
 * @package Plugin Name
 * @subpackage Installation
 */

class IPT_EXP_SQL_Install {

	/**
	 * Database prefix
	 * Mainly used for MS compatibility
	 *
	 * @var string
	 */
	public $prefix;

	public function __construct() {
		global $wpdb;
		$prefix = '';
		if ( is_multisite() ) {
			global $blog_id;
			$prefix = $wpdb->base_prefix . $blog_id . '_';
		} else {
			$prefix = $wpdb->prefix;
		}

		$this->prefix = $prefix;
	}

	/**
	 * install
	 * Do the things
	 */
	public function install( $networkwide = false ) {
		if ( $networkwide ) {
			deactivate_plugins( plugin_basename( IPT_EXP_SQL_Loader::$abs_file ) );
			wp_die( __( 'The plugin can not be network activated.', 'ipt_exp_sql' ) );
		}
		$this->checkop();
	}

	public function master_reset() {
		$this->restore_op();
	}

	/**
	 * Restores the WP Options to the defaults
	 * Deletes the default options set and calls checkop
	 */
	public function restore_op() {
		delete_option( 'ipt_exp_sql_info' );
		$this->checkop();
	}

	/**
	 * Checks whether PHP version 5 or greater is installed or not
	 * Also checks whether WordPress version is greater than or equal to the required
	 *
	 * If fails then it automatically deactivates the plugin
	 * and gives error
	 *
	 * @return void
	 */
	private function checkversions() {
		if ( version_compare( PHP_VERSION, '5.2', '<' ) ) {
			deactivate_plugins( plugin_basename( IPT_EXP_SQL_Loader::$abs_file ) );
			wp_die( __( 'The plugin requires PHP version greater than or equal to 5.2.x', 'ipt_exp_sql' ) );
			return;
		}

		if ( ! class_exists( 'IPT_FSQM_Loader' ) ) {
			deactivate_plugins( plugin_basename( IPT_EXP_SQL_Loader::$abs_file ) );
			wp_die( __( 'The plugin requires eForm - WordPress Form Builder Plugin', 'ipt_lth' ) );
			return;
		}

		if ( version_compare( get_bloginfo( 'version' ), '4.0', '<' ) ) {
			deactivate_plugins( plugin_basename( IPT_EXP_SQL_Loader::$abs_file ) );
			wp_die( __( 'The plugin requires WordPress version greater than or equal to 3.5', 'ipt_exp_sql' ) );
			return;
		}
	}

	/**
	 * Creates the options
	 */
	public function checkop() {
		$prefix = $this->prefix;
		$ipt_exp_sql_info_default = array(
			'version' => IPT_EXP_SQL_Loader::$version,
		);


		if ( ! get_option( 'ipt_exp_sql_info', false ) ) {
			// Fresh installation
			add_option( 'ipt_exp_sql_info', $ipt_exp_sql_info_default );
		} else {
			// Update
			$old_op = get_option( 'ipt_exp_sql_info', array() );
			switch ( $old_op['version'] ) {
				default :
					break;
				case '1.0.0' :
					// Do something
					break;
			}

			update_option( 'ipt_exp_sql_info', $ipt_exp_sql_info_default );
		}

		global $ipt_exp_sql_info, $ipt_exp_sql_settings;
		$ipt_exp_sql_info = get_option( 'ipt_exp_sql_info' );
	}
}
