<?php
/**
 * IPT EXP_SQL Loader
 * The library of loader class
 *
 * @author Swashata <swashata4u@gmail.com>
 * @package Plugin Name
 * @subpackage Loader
 */

class IPT_EXP_SQL_Loader {

	/**
	 * The init classes used to generate the admin menu
	 * The class should initialize and hook itself
	 *
	 * @see /classes/admin-class.php and extend from the base abstract class
	 * @staticvar array
	 */
	static $init_classes = array();

	/**
	 *
	 *
	 * @staticvar string
	 * Holds the absolute path of the main plugin file directory
	 */
	static $abs_path;

	/**
	 *
	 *
	 * @staticvar string
	 * Holds the absolute path of the main plugin file
	 */
	static $abs_file;

	/**
	 * Holds the text domain
	 * Use the string directly instead
	 * But still set this for some methods, especially the loading of the textdomain
	 */
	static $text_domain;

	/**
	 *
	 *
	 * @staticvar string
	 * The current version of the plugin
	 */
	static $version;

	/**
	 *
	 *
	 * @staticvar string
	 * The exp_sqleviated name of the plugin
	 * Mainly used for the enqueue style and script of the default admin.css and admin.js file
	 */
	static $exp_sql;

	/**
	 * The Documentation Link - From InTechgrity
	 *
	 * @var string
	 */
	static $documentation;

	/**
	 * The support forum link - From WordPress Extends
	 *
	 * @var string
	 */
	static $support_forum;


	/**
	 * Constructor function
	 *
	 * @global array $ipt_exp_sql_info The information option variable
	 * @param type    $file_loc
	 * @param type    $classes
	 * @param type    $text_domain
	 * @param type    $version
	 * @param type    $exp_sql
	 */
	public function __construct( $file_loc, $text_domain = 'default', $version = '1.0.0', $exp_sql = '', $doc = '', $sup = '' ) {
		self::$abs_path = dirname( $file_loc );
		self::$abs_file = $file_loc;
		self::$text_domain = $text_domain;
		self::$version = $version;
		self::$exp_sql = $exp_sql;
		self::$init_classes = array( 'IPT_EXP_SQL_Check_Form' );
		self::$documentation = $doc;
		self::$support_forum = $sup;
		global $ipt_exp_sql_info;
		$ipt_exp_sql_info = get_option( 'ipt_exp_sql_info' );
	}

	public function load() {
		// activation hook
		register_activation_hook( self::$abs_file, array( $this, 'plugin_install' ) );
		// deactivation hook
		register_deactivation_hook( self::$abs_file, array( $this, 'plugin_deactivate' ) );
		// Load Text Domain For Translations //
		add_action( 'plugins_loaded', array( $this, 'plugin_textdomain' ) );
		// Check for version and database compatibility //
		add_action( 'plugins_loaded', array( $this, 'database_version' ) );


		//admin area
		if ( is_admin() ) {
			// admin menu items
			// We just pass in the new menus to FSQM
			add_filter( 'ipt_fsqm_admin_menus', array( $this, 'admin_menus' ) );
		} else {

		}

		require_once self::$abs_path . '/classes/class-ipt-fsqm-direct-admin.php';
		$exp_sql_direct = new IPT_FSQM_Direct_Admin();

		// Add actions for auto insert
		add_action( 'ipt_fsqm_hook_save_insert', array( $this, 'sql_insert' ), 10, 1 );
		add_action( 'ipt_fsqm_hook_save_update', array( $this, 'sql_insert' ), 10, 1 );
	}

	public function sql_insert( $context ) {
		require_once self::$abs_path . '/classes/class-ipt-fsqm-form-elements-sql.php';
		$sql_insert = new IPT_FSQM_Form_Elements_SQL( $context->data_id );
		$sql_insert->save_to_table( $context );
	}

	public function admin_menus( $admin_classes ) {
		require_once self::$abs_path . '/classes/class-ipt-exp-sql-admin.php';
		$admin_classes[] = 'IPT_EXP_SQL_Check_Form';
		return $admin_classes;
	}

	public function plugin_install( $networkwide = false ) {
		include_once self::$abs_path . '/classes/class-ipt-exp-sql-install.php';

		$install = new IPT_EXP_SQL_Install();
		$install->install( $networkwide );

		// Scheduler
		wp_schedule_event( time(), 'daily', 'ipt_exp_sql_cron' );
	}

	public function plugin_deactivate() {
		wp_clear_scheduled_hook( 'ipt_exp_sql_cron' );
	}

	public function database_version() {
		global $ipt_exp_sql_info;
		$d_version = $ipt_exp_sql_info['version'];
		$s_version = self::$version;

		if ( $d_version != $s_version ) {
			include_once self::$abs_path . '/classes/class-ipt-exp-sql-install.php';

			$install = new IPT_EXP_SQL_Install();
			$install->checkop();
		}
	}

	/**
	 * Load the text domain on plugin load
	 * Hooked to the plugins_loaded via the load method
	 *
	 * dirname( plugin_basename( self::$abs_file ) )
	 */
	public function plugin_textdomain() {
		load_plugin_textdomain( 'ipt_exp_sql', false, basename( dirname( self::$abs_file ) ) . '/translations' );
	}
}
