<?php

class IPT_FSQM_Direct_Admin {
	public $ui;
	public $settings;
	public $that;
	public function __construct() {
		// Settings Panel
		add_filter( 'ipt_fsqm_filter_default_settings', array( $this, 'modify_settings' ), 10 );
		add_filter( 'ipt_fsqm_admin_tab_settings', array( $this, 'fsqm_builder_tabs' ), 10, 2 );

		// Database Creation
		add_action( 'ipt_fsqm_form_updated', array( $this, 'create_direct_table_on_save' ), 10, 2 );
		add_action( 'ipt_fsqm_form_created', array( $this, 'create_direct_table_on_save' ), 10, 2 );

		// Auto delete of submission exports
		add_action( 'ipt_fsqm_submissions_deleted', array( $this, 'delete_sql_exports' ), 10, 1 );
	}

	public function modify_settings( $settings ) {
		$settings['direct_exp'] = array(
			'enabled' => false,
			'drop_deleted' => true,
			'excludes' => '',
			'total_limit' => '',
			'day_limit' => '',
			'mod' => '\n', // Multiple Options Delimiter
			'frd' => '/', // Field Range Delimiter
			'mrd' => '\n\n', // Multiple Row Delimiter
			'med' => ':', // Multi Entry Delimiter
			'keep_old' => false,
		);
		return $settings;
	}

	public function fsqm_builder_tabs( $tab_settings, $context ) {
		$tab_settings[] = array(
			'id' => 'ipt_fsqm_form_exp_sql',
			'label' => __( 'SQL Export', 'ipt_exp_sql' ),
			'callback' => array( $this, 'fsqm_builder_exp_sql' ),
			'has_inner_tab' => false,
		);
		$this->settings = $context->settings;
		$this->that = $context;

		return $tab_settings;
	}

	public function fsqm_builder_exp_sql() {
		global $wpdb;
		$this->ui = IPT_Plugin_UIF_Admin::instance( 'ipt_fsqm' );
		$op = $this->settings['direct_exp'];
		?>
<table class="form-table">
	<tbody>
		<tr>
			<th><?php $this->ui->generate_label( 'settings[direct_exp][enabled]', __( 'Enable Direct SQL Export', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->toggle( 'settings[direct_exp][enabled]', __( 'Yes', 'ipt_exp_sql' ), __( 'No', 'ipt_exp_sql' ), $op['enabled'], '1', false, true, array(
					'condid' => 'ipt_fsqm_exp_sql_drop_deleted_wrap,ipt_fsqm_exp_sql_excludes_wrap,ipt_fsqm_exp_sql_mod_wrap,ipt_fsqm_exp_sql_frd_wrap,ipt_fsqm_exp_sql_mrd_wrap,ipt_fsqm_exp_sql_total_limit_wrap,ipt_fsqm_exp_sql_day_limit_wrap,ipt_fsqm_exp_sql_keep_old_wrap,ipt_fsqm_exp_sql_med_wrap',
				) ); ?>
				<?php if ( $this->that->form_id != null ) : ?>
				<span class="description"><?php printf( __( 'If enabled data will saved under the table <code>%1$s</code>', 'ipt_exp_sql' ), $wpdb->prefix . 'fsqm_direct_' . $this->that->form_id ); ?></span>
				<?php endif; ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enabling this would make all upcoming submissions go directly into a database table. The table name would be <code>fsqm_direct_{$form_id}</code>.', 'ipt_fsqm' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_drop_deleted_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][drop_deleted]', __( 'Drop Deleted Element Columns', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->toggle( 'settings[direct_exp][drop_deleted]', __( 'Yes', 'ipt_exp_sql' ), __( 'No', 'ipt_exp_sql' ), $op['drop_deleted'] ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enabling this would delete columns corresponding to non existent form elements.', 'ipt_fsqm' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_keep_old_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][keep_old]', __( 'Keep Old Submission on update (Revision Control)', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->toggle( 'settings[direct_exp][keep_old]', __( 'Yes', 'ipt_exp_sql' ), __( 'No', 'ipt_exp_sql' ), $op['keep_old'] ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enabling this would keep old submissions during user update. It will add the ID of the oldest submission to the <code>ref</code> column of the table. Through Form Auto Exports, you will also be able to see the revisions.', 'ipt_fsqm' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_excludes_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][excludes]', __( 'Exclude List', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->text( 'settings[direct_exp][excludes]', $op['excludes'], __( 'Comma Separated', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Comma Separated short notations of fields to exclude from export. Like <br /><code>m0</code>: MCQ 0<br /><code>f10</code>:Freetype 10<br /><code>o12</code>: Other 12.<br/>To include them all <code>m0,f10,o12</code>.', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_total_limit_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][total_limit]', __( 'Limit Total Number of Exports', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[direct_exp][total_limit]', $op['total_limit'], __( 'Disabled', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'If you want to limit the total number of exports for the table, then please mention it here. It should be a numeric greater than 0. For example, if you mention 50, then a total of 50 exports will be saved in the table. When new exports are made, older would be deleted.', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_day_limit_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][day_limit]', __( 'Limit for last n days', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->spinner( 'settings[direct_exp][day_limit]', $op['day_limit'], __( 'Disabled', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'You can limit the exports for last n days. If you enter here <code>30</code>, then exports from last 30 days would be saved.', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_mod_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][mod]', __( 'Multiple Options Delimiter', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->text( 'settings[direct_exp][mod]', $op['mod'], __( 'Can not be empty', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enter the Multiple Option Delimiter (For questions like Multiple Options, Matrix etc). Default is <code>\n</code> (New line character).', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_frd_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][frd]', __( 'Field Range Delimiter', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->text( 'settings[direct_exp][frd]', $op['frd'], __( 'Can not be empty', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enter the Range Delimiter (For questions like Grading, Ranges etc). Default is <code>/</code>.', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_mrd_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][mrd]', __( 'Multiple Row Delimiter', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->text( 'settings[direct_exp][mrd]', $op['mrd'], __( 'Can not be empty', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enter the Multiple Row Delimiter (For questions like Grading, Spinners, Matrix etc). Default is <code>\n\n</code> (Double new line characters).', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
		<tr id="ipt_fsqm_exp_sql_med_wrap">
			<th><?php $this->ui->generate_label( 'settings[direct_exp][med]', __( 'Multiple Entry Delimiter', 'ipt_exp_sql' ) ); ?></th>
			<td>
				<?php $this->ui->text( 'settings[direct_exp][med]', $op['med'], __( 'Can not be empty', 'ipt_exp_sql' ) ); ?>
			</td>
			<td>
				<?php $this->ui->help( __( 'Enter the field Entry Delimiter (For the options inside elements like Grading, Spinners, Matrix etc).  Default is <code>:</code>.', 'ipt_exp_sql' ) ); ?>
			</td>
		</tr>
	</tbody>
</table>
		<?php
	}

	public function create_direct_table_on_save( $form_id, $context ) {
		if ( $form_id == null ) {
			return;
		}

		// Create a new instance
		$form = new IPT_FSQM_Form_Elements_Base( $form_id );
		if ( $form->form_id == null ) {
			return;
		}
		$form_id = $form->form_id;

		// Check settings
		if ( $form->settings['direct_exp']['enabled'] == false ) {
			return;
		}
		/**
		 * Include the necessary files
		 * Also the global options
		 */
		if ( file_exists( ABSPATH . 'wp-admin/includes/upgrade.php' ) ) {
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		} else {
			require_once ABSPATH . 'wp-admin/upgrade-functions.php';
		}
		global $charset_collate, $wpdb;

		// Set table name
		$table_name = $wpdb->prefix . 'fsqm_direct_' . $form_id;

		// Get existing columns
		$existing_columns = false;
		if ( $wpdb->get_var( "SHOW TABLES LIKE '{$table_name}'" ) == $table_name ) {
			$existing_columns = @$wpdb->get_col( "DESC {$table_name}" );
		}

		if ( ! $existing_columns ) {
			$existing_columns = array();
		}

		$blacklisted_columns = array();
		$blacklisted_columns = explode( ',', strtolower( $form->settings['direct_exp']['excludes'] ) );

		$necessary_columns = array();
		$necessary_columns[] = 'id';
		$necessary_columns[] = 'data_id';
		$necessary_columns[] = 'updated';
		$necessary_columns[] = 'form_id';
		$necessary_columns[] = 'ref';

		// Initiate the table query
		$table_query = "CREATE TABLE {$table_name}\n (";
		$table_query .= "id BIGINT(20) UNSIGNED NOT NULL auto_increment,\n";
		$table_query .= "data_id BIGINT(20) UNSIGNED default NULL,\n";
		$table_query .= "updated DATETIME NOT NULL default '0000-00-00 00:00:00',\n";
		$table_query .= "form_id BIGINT(20) UNSIGNED NOT NULL default '" . $form_id . "',\n";
		$table_query .= "ref BIGINT(20) UNSIGNED NOT NULL default '0',\n";

		// Loop through all questions and add columns for them as well
		foreach ( ( array ) $form->mcq as $m_key => $mcq ) {
			$column_name = 'mcq' . $m_key;
			if ( in_array( 'm' . $m_key, (array) $blacklisted_columns ) ) {
				continue;
			}
			$necessary_columns[] = $column_name;
			$comment = $this->get_column_name_comment( $mcq['title'] );
			$table_query .= $wpdb->prepare( "{$column_name} TEXT NOT NULL COMMENT %s,\n", $comment );
		}
		foreach ( ( array ) $form->freetype as $f_key => $freetype ) {
			$column_name = 'freetype' . $f_key;
			if ( in_array( 'f' . $f_key, (array) $blacklisted_columns ) ) {
				continue;
			}
			$necessary_columns[] = $column_name;
			$comment = $this->get_column_name_comment( $freetype['title'] );
			$table_query .= $wpdb->prepare( "{$column_name} TEXT NOT NULL COMMENT %s,\n", $comment );
		}
		foreach ( ( array ) $form->pinfo as $p_key => $pinfo ) {
			$column_name = 'pinfo' . $p_key;
			if ( in_array( 'o' . $p_key, (array) $blacklisted_columns ) ) {
				continue;
			}
			$necessary_columns[] = $column_name;
			$comment = $this->get_column_name_comment( $pinfo['title'] );
			$table_query .= $wpdb->prepare( "{$column_name} TEXT NOT NULL COMMENT %s,\n", $comment );
		}

		// Finalize the query
		$table_query .= "UNIQUE KEY data_id (data_id),\n";
		$table_query .= "INDEX ref (ref),\n";
		$table_query .= "PRIMARY KEY  (id)\n";
		$table_query .= ") $charset_collate;";

		dbDelta( $table_query );

		// // Log if WP_DEBUG
		// if ( defined( 'WP_DEBUG' ) && WP_DEBUG && function_exists( 'ipt_error_log' ) ) {
		// 	ipt_error_log( $table_query );
		// }

		// Compute columns to drop
		$drop_columns = array_diff( $existing_columns, $necessary_columns );
		if ( ! empty( $drop_columns ) && $form->settings['direct_exp']['drop_deleted'] == true ) {
			$wpdb->query( "ALTER TABLE {$table_name} DROP COLUMN " . implode( ', DROP COLUMN ', $drop_columns ) . ";" );
		}
	}

	private function get_column_name_comment( $title ) {
		// return substr( $title, 0, 60 );
		// We need to sanitize it, otherwise mySQL will throw up
		// Remove tags
		$title = strip_tags( $title );
		$title = html_entity_decode( $title );
		// Remove all unsupported characters
		$title = preg_replace( '/[&;]/', '', $title );

		// Shorten length
		return substr( $title, 0, 60 );
	}

	public function delete_sql_exports( $ids ) {
		if ( empty( $ids ) ) {
			return;
		}
		require_once IPT_EXP_SQL_Loader::$abs_path . '/classes/class-ipt-fsqm-form-elements-sql.php';
		foreach ( (array) $ids as $data_id ) {
			$exp_sql = new IPT_FSQM_Form_Elements_SQL( $data_id );
			$exp_sql->delete_export();
		}
	}
}
