<?php
/**
 * Exporter for eForm Widget
 *
 * Adds a widget to display persistent trends on sidebars
 *
 * @package eForm - WordPress Form Builder
 * @subpackage Widgets
 * @author Swashata Ghosh <swashata@ipanelthemes.com>
 */

// TODO
// This will be implemented in v4.0
// When we will refurbish the reports section
// to include all kinds of question elements
class IPT_FSQM_EXP_PTrends_Widget extends WP_Widget {

	/*==========================================================================
	 * Static methods
	 *========================================================================*/
	public static $instantiated = false;

	public static function init() {
		if ( true === self::$instantiated ) {
			return;
		}
		self::$instantiated = true;

		// We use lambda function because PHP 5.3 supports it
		// After introducing Payments Gateway
		// We needed to increase minimum PHP requirement to 5.3
		add_action( 'widgets_init', function() {
			register_widget( 'IPT_FSQM_EXP_PTrends_Widget' );
		} );
	}


	/*==========================================================================
	 * Widget methods
	 *========================================================================*/

	/**
	 * Constructor
	 */
	public function __construct() {
		$widget_ops = array(
			// We keep the classname same for the main plugin JS to hook in
			'classname' => 'ipt_fsqm_trends_widget',
			'description' => __( 'Insert eForm persistent reports and analytics to your sidebars.', 'ipt_fsqm_exp' ),
		);
		parent::__construct( 'ipt_fsqm_exp_ptrends_widget', __( 'eForm - Insert Persistent Trends', 'ipt_fsqm_exp' ), $widget_ops );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		// Get widget arguments
		extract( $args, EXTR_SKIP );
		echo $before_widget;

		// Widget title
		$title = apply_filters( 'widget_title', $instance['title'] );

		if ( '' !== $title ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}

		// Create the parameters

		// Loop through the mcqs
		// And enable report type if needed
		$mcq_report = false;
		$mcqs = array();
		$cmeta = array(
			'mcq' => array(
				'charttype' => array(),
				'toggles' => array(),
			),
		);
		foreach ( $instance['mcqs'] as $m_key => $mcq ) {
			if ( true === $mcq['enabled'] ) {
				// Add to the list
				$mcqs[] = $m_key;

				// Add to the chart config
				if ( isset( $mcq['charttype'] ) ) {
					$cmeta['mcq']['charttype'][ $m_key ] = $mcq['charttype'];
				}
				if ( isset( $mcq['toggles'] ) ) {
					$cmeta['mcq']['toggles'][ $m_key ] = $mcq['toggles'];
				}
			}
		}

		// Loop through the pinfos
		// And enable report type if needed
		$pinfos = array();
		$cmeta['pinfo'] = array(
			'charttype' => array(),
			'toggles' => array(),
		);
		// complete the loop
		foreach ( $instance['pinfos'] as $p_key => $pinfo ) {
			if ( true === $pinfo['enabled'] ) {
				// Add to the list
				$pinfos[] = $p_key;

				// Add to the chart config
				if ( isset( $pinfo['charttype'] ) ) {
					$cmeta['pinfo']['charttype'][ $p_key ] = $pinfo['charttype'];
				}
				if ( isset( $pinfo['toggles'] ) ) {
					$cmeta['pinfo']['toggles'][ $p_key ] = $pinfo['toggles'];
				}
			}
		}

		// Other presets
		$appearance = array(
			'wrap' => false,
			'heading' => ( true == $instance['heading'] ) ? true : false,
			'description' => false,
			'theader' => false,
			'tborder' => false,
			'material' => ( true == $instance['material'] ) ? true : false,
			'print' => ( true == $instance['print'] ) ? true : false,
		);

		$data = array(
			'data' => false,
			'others' => false,
			'names' => false,
			'date' => false,
		);

		// Main Widget output
		// Get the exp_data for form_id
		$exp_data = IPT_FSQM_EXP_Export_API::get_exp_data( $instance['exp_id'] );
		// Create a dummy form just in case
		if ( false === $exp_data ) {
			$exp_data = new stdClass();
			$exp_data->form_id = 0;
		}
		// Create the main front instance
		$form = new IPT_FSQM_Form_Elements_Front( null, $exp_data->form_id );
		// Create the persistent report parameters
		$persistent_report_param = array(
			$instance['exp_id'], // $exp_id
			null, // $ui
			'', // $visualization
			$mcqs, // $mcqs
			array(), // $freetypes
			$pinfos, // $pinfos
			$appearance, // $appearance
			$data, // $data
			$cmeta, // $cmeta
		);

		// Get the output
		ob_start();
		$form->container( array( array( 'IPT_FSQM_EXP_Export_API', 'persistent_report' ), $persistent_report_param ) );
		$output = ob_get_clean();

		if ( WP_DEBUG !== true ) {
			require_once IPT_FSQM_Loader::$abs_path . '/lib/classes/class-minify-html.php';
			$output = IPT_FSQM_Minify_HTML::minify( $output );
		}

		echo $output;

		echo $after_widget;
	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		global $wpdb, $ipt_fsqm_info, $ipt_fsqm_exp_info;

		// Parse the default form settings
		$instance = wp_parse_args( (array) $instance, array(
			'title' => '',
			'exp_id' => '0', // This is actually the exp_id, we keep the classname because the way original widget.js interacts
			'material' => false,
			'heading' => false,
			'print' => false,
			'mcqs' => array(),
			'pinfos' => array(),
			'mcqwrap' => '0',
			'pinfowrap' => '0',
			'filterwrap' => '0',
		) );

		// Get exports
		$exports = IPT_FSQM_EXP_Export_API::get_exports();

		// Process the chart types beforehand
		$chart_types_n_toggles = IPT_FSQM_Form_Elements_Static::get_chart_type_n_toggles();
		$chart_lists = IPT_FSQM_EXP_Export_API::get_exp_chart_elements( $instance['exp_id'] );

		// Loop through mcqs and process
		$mcqs = array();
		foreach ( $chart_lists['mcqs'] as $mcq ) {
			// Add the main array
			if ( isset( $instance['mcqs'][ $mcq['key'] ] ) ) {
				$mcqs[ $mcq['key'] ] = $instance['mcqs'][ $mcq['key'] ];
			} else {
				$mcqs[ $mcq['key'] ] = array(
					'enabled' => true,
				);
			}

			// Add chart type
			if ( isset( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] )
				&& ! isset( $instance['mcqs'][ $mcq['key'] ]['charttype'] )
				) {
				$array_keys  = array_keys( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] );
				$mcqs[ $mcq['key'] ]['charttype'] = $array_keys[0];
				unset( $array_keys );
			}

			// Add toggles
			if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] )
				&& ! isset( $instance['mcqs'][ $mcq['key'] ]['toggles'] )
				) {
				$mcqs[ $mcq['key'] ]['toggles'] = array();
				foreach ( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] as $toggle ) {
					$mcqs[ $mcq['key'] ]['toggles'][ $toggle ] = true;
				}
			}
		}
		$instance['mcqs'] = $mcqs;

		// Loop through pinfos and process
		$pinfos = array();
		foreach ( $chart_lists['pinfos'] as $pinfo ) {
			// Add the main array
			if ( isset( $instance['pinfos'][ $pinfo['key'] ] ) ) {
				$pinfos[ $pinfo['key'] ] = $instance['pinfos'][ $pinfo['key'] ];
			} else {
				$pinfos[ $pinfo['key'] ] = array(
					'enabled' => true,
				);
			}

			// Add chart type
			if ( isset( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] )
				&& ! isset( $instance['pinfos'][ $pinfo['key'] ]['charttype'] )
				) {
				$array_keys = array_keys( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] );
				$pinfos[ $pinfo['key'] ]['charttype'] = $array_keys[0];
				unset( $array_keys );
			}

			// Add toggles
			if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] )
				&& ! isset( $instance['pinfos'][ $pinfo['key'] ]['toggles'] )
				) {
				$pinfos[ $pinfo['key'] ]['toggles'] = array();
				foreach ( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] as $toggle ) {
					$pinfos[ $pinfo['key'] ]['toggles'][ $toggle ] = true;
				}
			}
		}
		$instance['pinfos'] = $pinfos;
		?>
		<div class="ipt_fsqm_tw_outer">
			<input type="hidden" class="ipt_fsqm_tw_mcqwrap" value="<?php echo (int) $instance['mcqwrap'] ?>" name="<?php echo $this->get_field_name( 'mcqwrap' ) ?>" />
			<input type="hidden" class="ipt_fsqm_tw_pinfowrap" value="<?php echo (int) $instance['pinfowrap'] ?>" name="<?php echo $this->get_field_name( 'pinfowrap' ) ?>" />
			<input type="hidden" class="ipt_fsqm_tw_filterwrap" value="<?php echo (int) $instance['filterwrap'] ?>" name="<?php echo $this->get_field_name( 'filterwrap' ) ?>" />
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><strong><?php _e( 'Title', 'ipt_kb' ) ?></strong></label>
				<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'title' ); ?>" id="<?php echo $this->get_field_id( 'title' ); ?>" value="<?php echo esc_html( $instance['title'] ); ?>" />
			</p>
			<p>
				<input type="checkbox" name="<?php echo $this->get_field_name( 'heading' ); ?>" id="<?php echo $this->get_field_id( 'heading' ); ?>" value="1" <?php checked( $instance['heading'] ); ?> />
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>"><?php _e( 'Show heading (element title) above chart', 'ipt_fsqm_exp' ); ?></label>
			</p>
			<p>
				<input type="checkbox" name="<?php echo $this->get_field_name( 'print' ); ?>" id="<?php echo $this->get_field_id( 'print' ); ?>" value="1" <?php checked( $instance['print'] ); ?> />
				<label for="<?php echo $this->get_field_id( 'print' ); ?>"><?php _e( 'Show print button', 'ipt_fsqm_exp' ); ?></label>
			</p>
			<p>
				<input type="checkbox" name="<?php echo $this->get_field_name( 'material' ); ?>" id="<?php echo $this->get_field_id( 'material' ); ?>" value="1" <?php checked( $instance['material'] ); ?> />
				<label for="<?php echo $this->get_field_id( 'material' ); ?>"><?php _e( 'Show material design chart (when applicable)', 'ipt_fsqm_exp' ); ?></label>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'exp_id' ); ?>"><?php _e( 'Select Export', 'ipt_fsqm_exp' ); ?></label>
				<select class="widefat ipt_fsqm_tw_form_id" name="<?php echo $this->get_field_name( 'exp_id' ); ?>" id="<?php echo $this->get_field_id( 'exp_id' ); ?>">
					<option value="0"<?php selected( $instance['exp_id'], '0', true ); ?>><?php _e( '--please select an export--', 'ipt_fsqm_exp' ); ?></option>
					<?php if ( ! empty( $exports ) ) : ?>
					<?php foreach ( $exports as $export ) : ?>
					<option value="<?php echo $export->id; ?>"<?php selected( $instance['exp_id'], $export->id, true ) ?>><?php echo $export->name . ' ( ' . $export->created . ' )'; ?></option>
					<?php endforeach; ?>
					<?php endif; ?>
				</select>
			</p>
			<?php if ( '0' == $instance['exp_id'] ) : ?>
				<p><span class="description"><?php _e( 'Please select an export and SAVE in order to continue', 'ipt_fsqm_exp' ); ?></span></p>
			<?php else : ?>
				<p><span class="description"><?php _e( 'Changing the export will reset the following data.', 'ipt_fsqm_exp' ); ?></span></p>

				<?php // Add the mcq list ?>
				<div class="ipt_fsqm_tw_mcqs ipt_fsqm_tw" data-target="ipt_fsqm_tw_mcqwrap">
					<h2 class="ipt_fsqm_tw_qlist_toggle" title="<?php _e( 'Click to expand/collapse', 'ipt_fsqm_exp' ); ?>"><i class="dashicons dashicons-chart-area"></i> <?php _e( 'Select MCQs', 'ipt_fsqm_exp' ); ?></h2>
					<div class="ipt_fsqm_tw_qlist_wrap" style="display: <?php echo ( '0' == $instance['mcqwrap'] ) ? 'none' : 'block'; ?>;">
						<?php foreach ( $chart_lists['mcqs'] as $mcq ) : ?>
							<div id="ipt_fsqm_tw_mcq_<?php echo $mcq['key']; ?>" class="ipt_fsqm_tw_qlist <?php echo ( true !== $instance['mcqs'][ $mcq['key'] ]['enabled'] ) ? 'qlist_hidden' : ''; ?>">
								<h3><input class="ipt_fsqm_tw_mcq_elm ipt_fsqm_tw_elm" type="checkbox" <?php checked( $instance['mcqs'][ $mcq['key'] ]['enabled'] ); ?> name="<?php echo $this->get_field_name( 'mcqs[' . $mcq['key'] . '][enabled]' ); ?>" id="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][enabled]' ); ?>" value="1" />
								<label for="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][enabled]' ); ?>"><?php echo $mcq['title']; ?></label></h3>

								<div class="ipt_fsqm_tw_cmeta">
									<?php // Add charttype ?>
									<?php if ( isset( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] ) && isset( $instance['mcqs'][ $mcq['key'] ]['charttype'] ) ) : ?>
										<div class="ipt_fsqm_tw_ctype">
											<label for="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][charttype]' ); ?>"><?php _e( 'Select Chart', 'ipt_fsqm_exp' ); ?></label>
											<select class="" name="<?php echo $this->get_field_name( 'mcqs[' . $mcq['key'] . '][charttype]' ); ?>" id="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][charttype]' ); ?>">
												<?php foreach ( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] as $chart => $clabel ) : ?>
													<option value="<?php echo esc_attr( $chart ); ?>" <?php selected( $instance['mcqs'][ $mcq['key'] ]['charttype'], $chart ); ?>><?php echo $clabel; ?></option>
												<?php endforeach; ?>
											</select>
										</div>
									<?php endif; ?>

									<?php // Add Toggles ?>
									<?php if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] ) && isset( $instance['mcqs'][ $mcq['key'] ]['toggles'] ) ) : ?>
										<div class="ipt_fsqm_tw_toggles">
											<?php foreach ( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] as $toggle ) : ?>
												<p><input type="checkbox" <?php checked( $instance['mcqs'][ $mcq['key'] ]['toggles'][ $toggle ] ); ?> name="<?php echo $this->get_field_name( 'mcqs[' . $mcq['key'] . '][toggles][' . $toggle . ']' ); ?>" id="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][toggles][' . $toggle . ']' ); ?>" value="1" />
												<label for="<?php echo $this->get_field_id( 'mcqs[' . $mcq['key'] . '][toggles][' . $toggle . ']' ); ?>"><?php echo $chart_types_n_toggles['toggle_labels'][ $toggle ]; ?></label></p>
											<?php endforeach; ?>
										</div>
									<?php endif; ?>
								</div>

							</div>
						<?php endforeach; ?>
						<?php if ( empty( $chart_lists['mcqs'] ) ) : ?>
						<p><span class="description"><?php _e( 'No Elements found in your form', 'ipt_fsqm_exp' ); ?></span></p>
						<?php endif; ?>
					</div>
				</div>

				<div class="ipt_fsqm_tw_pinfos ipt_fsqm_tw" data-target="ipt_fsqm_tw_pinfowrap">
					<?php // Add the pinfo list ?>
					<h2 class="ipt_fsqm_tw_qlist_toggle" title="<?php _e( 'Click to expand/collapse', 'ipt_fsqm_exp' ); ?>"><i class="dashicons dashicons-chart-area"></i> <?php _e( 'Select Other Elements', 'ipt_fsqm_exp' ); ?></h2>
					<div class="ipt_fsqm_tw_qlist_wrap" style="display: <?php echo ( '0' == $instance['pinfowrap'] ) ? 'none' : 'block'; ?>;">
						<?php foreach ( $chart_lists['pinfos'] as $pinfo ) : ?>
							<div id="ipt_fsqm_tw_pinfo_<?php echo $pinfo['key']; ?>" class="ipt_fsqm_tw_qlist <?php echo ( true !== $instance['pinfos'][ $pinfo['key'] ]['enabled'] ) ? 'qlist_hidden' : ''; ?>">
								<h3><input class="ipt_fsqm_tw_mcq_elm ipt_fsqm_tw_elm" type="checkbox" <?php checked( $instance['pinfos'][ $pinfo['key'] ]['enabled'] ); ?> name="<?php echo $this->get_field_name( 'pinfos[' . $pinfo['key'] . '][enabled]' ); ?>" id="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][enabled]' ); ?>" value="1" />
								<label for="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][enabled]' ); ?>"><?php echo $pinfo['title']; ?></label></h3>

								<div class="ipt_fsqm_tw_cmeta">
									<?php // Add charttype ?>
									<?php if ( isset( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] ) && isset( $instance['pinfos'][ $pinfo['key'] ]['charttype'] ) ) : ?>
										<div class="ipt_fsqm_tw_ctype">
											<label for="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][charttype]' ); ?>"><?php _e( 'Select Chart', 'ipt_fsqm_exp' ); ?></label>
											<select class="" name="<?php echo $this->get_field_name( 'pinfos[' . $pinfo['key'] . '][charttype]' ); ?>" id="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][charttype]' ); ?>">
												<?php foreach ( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] as $chart => $clabel ) : ?>
													<option value="<?php echo esc_attr( $chart ); ?>" <?php selected( $instance['pinfos'][ $pinfo['key'] ]['charttype'], $chart ); ?>><?php echo $clabel; ?></option>
												<?php endforeach; ?>
											</select>
										</div>
									<?php endif; ?>

									<?php // Add Toggles ?>
									<?php if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] ) && isset( $instance['pinfos'][ $pinfo['key'] ]['toggles'] ) ) : ?>
										<div class="ipt_fsqm_tw_toggles">
											<?php foreach ( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] as $toggle ) : ?>
												<p><input type="checkbox" <?php checked( $instance['pinfos'][ $pinfo['key'] ]['toggles'][ $toggle ] ); ?> name="<?php echo $this->get_field_name( 'pinfos[' . $pinfo['key'] . '][toggles][' . $toggle . ']' ); ?>" id="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][toggles][' . $toggle . ']' ); ?>" value="1" />
												<label for="<?php echo $this->get_field_id( 'pinfos[' . $pinfo['key'] . '][toggles][' . $toggle . ']' ); ?>"><?php echo $chart_types_n_toggles['toggle_labels'][ $toggle ]; ?></label></p>
											<?php endforeach; ?>
										</div>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
						<?php if ( empty( $chart_lists['pinfos'] ) ) : ?>
						<p><span class="description"><?php _e( 'No Elements found in your form', 'ipt_fsqm_exp' ); ?></span></p>
						<?php endif; ?>
					</div>
				</div>
				<p><span class="description"><?php _e( 'Click on the headings to customize this widget options', 'ipt_fsqm_exp' ); ?></span></p>
			<?php endif; ?>
		</div>
		<?php
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		// Update the form
		$updated_instance = array();
		$updated_instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$updated_instance['exp_id'] = isset( $new_instance['exp_id'] ) ? (string) intval( $new_instance['exp_id'] ) : '0';
		$updated_instance['heading'] = isset( $new_instance['heading'] ) ? true : false;
		$updated_instance['material'] = isset( $new_instance['material'] ) ? true : false;
		$updated_instance['print'] = isset( $new_instance['print'] ) ? true : false;

		if ( ( '0' == $updated_instance['exp_id'] ) || ( $new_instance['exp_id'] != $old_instance['exp_id'] ) ) {
			$updated_instance['mcqs'] = array();
			$updated_instance['pinfos'] = array();
		} else {
			// Process the chart types beforehand
			$chart_types_n_toggles = IPT_FSQM_Form_Elements_Static::get_chart_type_n_toggles();
			$chart_lists = IPT_FSQM_EXP_Export_API::get_exp_chart_elements( $updated_instance['exp_id'] );

			// Loop through and set the mcqs
			$mcqs = array();
			foreach ( $chart_lists['mcqs'] as $mcq ) {
				// Add the main array
				$mcqs[ $mcq['key'] ] = array(
					'enabled' => false,
				);
				if ( isset( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] ) ) {
					$array_keys = array_keys( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] );
					$mcqs[ $mcq['key'] ]['charttype'] = $array_keys[0];
					unset( $array_keys );
				}
				if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] ) ) {
					$mcqs[ $mcq['key'] ]['toggles'] = array();
				}

				// Check if enabled
				if ( isset( $new_instance['mcqs'][ $mcq['key'] ]['enabled'] ) ) {
					$mcqs[ $mcq['key'] ]['enabled'] = true;
				}

				// Set the chart type
				if ( isset( $chart_types_n_toggles['possible_chart_types'][ $mcq['type'] ] ) && isset( $new_instance['mcqs'][ $mcq['key'] ]['charttype'] ) ) {
					$mcqs[ $mcq['key'] ]['charttype'] = $new_instance['mcqs'][ $mcq['key'] ]['charttype'];
				}

				// Set toggles
				if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] ) ) {
					foreach ( $chart_types_n_toggles['possible_toggle_types'][ $mcq['type'] ] as $toggle ) {
						if ( isset( $new_instance['mcqs'][ $mcq['key'] ]['toggles'][ $toggle ] ) ) {
							$mcqs[ $mcq['key'] ]['toggles'][ $toggle ] = true;
						} else {
							$mcqs[ $mcq['key'] ]['toggles'][ $toggle ] = false;
						}
					}
				}
			}
			$updated_instance['mcqs'] = (array) $mcqs;

			// Loop through and set the pinfos
			$pinfos = array();
			foreach ( $chart_lists['pinfos'] as $pinfo ) {
				// Add the main array
				$pinfos[ $pinfo['key'] ] = array(
					'enabled' => false,
				);
				if ( isset( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] ) ) {
					$array_keys = array_keys( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] );
					$pinfos[ $pinfo['key'] ]['charttype'] = $array_keys[0];
					unset( $array_keys );
				}
				if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] ) ) {
					$pinfos[ $pinfo['key'] ]['toggles'] = array();
				}

				// Check if enabled
				if ( isset( $new_instance['pinfos'][ $pinfo['key'] ]['enabled'] ) ) {
					$pinfos[ $pinfo['key'] ]['enabled'] = true;
				}

				// Set the chart type
				if ( isset( $chart_types_n_toggles['possible_chart_types'][ $pinfo['type'] ] ) && isset( $new_instance['pinfos'][ $pinfo['key'] ]['charttype'] ) ) {
					$pinfos[ $pinfo['key'] ]['charttype'] = $new_instance['pinfos'][ $pinfo['key'] ]['charttype'];
				}

				// Set toggles
				if ( isset( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] ) ) {
					foreach ( $chart_types_n_toggles['possible_toggle_types'][ $pinfo['type'] ] as $toggle ) {
						if ( isset( $new_instance['pinfos'][ $pinfo['key'] ]['toggles'][ $toggle ] ) ) {
							$pinfos[ $pinfo['key'] ]['toggles'][ $toggle ] = true;
						} else {
							$pinfos[ $pinfo['key'] ]['toggles'][ $toggle ] = false;
						}
					}
				}
			}
			$updated_instance['pinfos'] = (array) $pinfos;
		}

		// Add the collapse states
		$updated_instance['mcqwrap'] = (string) intval( $new_instance['mcqwrap'] );
		$updated_instance['pinfowrap'] = (string) intval( $new_instance['pinfowrap'] );
		$updated_instance['filterwrap'] = (string) intval( $new_instance['filterwrap'] );

		return $updated_instance;
	}
}

IPT_FSQM_EXP_PTrends_Widget::init();
